<?php

namespace App\Controllers;

class Home extends BaseController
{
    
    public $session;
    public $db;
    public $data;

    public function __construct()
    {
        $this->request = \Config\Services::request();
        $this->session = session();
        $this->db = db_connect();
        $this->data = ['session' => $this->session,'request'=>$this->request];
    }

    public function index()
    {   
        $this->data['page_title'] = "Expert Market Research & Data Insights | ".$_ENV['app.Name'];
        $this->data['page_description'] = "Gain data-driven insights with ".$_ENV['app.Name'].". We provide expert market research, industry analysis, and strategic intelligence to drive business success.";
        $this->data['page_keywords'] = "market research, business insights, data analysis, industry trends, consumer behavior, competitive intelligence, business consulting, data-driven decisions, market analysis, research reports, market forecasting, strategic insights, industry research, business growth strategies";
        return view('home', $this->data);
    }

    public function aboutus()
    {   
        $this->data['page_title'] = "About Us | Market Research & Business Insights | ".$_ENV['app.Name'];
        $this->data['page_description'] = "Discover how ".$_ENV['app.Name']." delivers expert market research, data insights, and strategic intelligence to help businesses grow and stay competitive.";
        $this->data['page_keywords'] = "about us, market research company, business insights, data analysis, competitive intelligence, industry trends, research solutions, strategic consulting, consumer behavior, market analysis, research experts, business growth, data-driven decisions";
        return view('about', $this->data);
    }

    public function contactus()
    {
        $this->data['page_title'] = "Contact Us | Market Research & Business Insights | ".$_ENV['app.Name'];
        $this->data['page_description'] = "Get in touch with ".$_ENV['app.Name']." for expert market research, data insights, and strategic consulting. Contact us today to drive your business forward.";
        $this->data['page_keywords'] = "contact us, market research company, business insights, data analysis, industry trends, research consulting, competitive intelligence, strategy consulting, data-driven solutions, market analysis, research services, expert insights, business growth strategies";
        return view('contact', $this->data);
    }
}
