<!doctype html>
<html class="no-js" lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?= isset($page_title) ? $page_title : env('app.Name') ?></title>
    <meta name="description" content="<?= isset($page_description) ? $page_description : env('app.Name') ?>">
    <meta name="keywords" content="<?= isset($page_keywords) ? $page_keywords : env('app.Name') ?>">
    <meta name="robots" content="noindex, nofollow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="<?=base_url('uploads/favicon.png');?>">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    <link rel="stylesheet" href="<?=base_url();?>assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/animate.min.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/magnific-popup.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/tg-flaticon.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/default.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/default-icons.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/odometer.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/aos.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/tg-cursor.css">
    <link rel="stylesheet" href="<?=base_url();?>assets/css/main.css">

<!-- Open Graph / Facebook -->
<meta property="og:type" content="article">
<meta property="og:url" content="<?=base_url();?>">
<meta property="og:title" content="<?= isset($page_title) ? $page_title : env('app.Name') ?><?= env('system_name') ?>">
<meta property="og:description" content="<?= isset($page_description) ? $page_description : env('app.Name') ?>">
<meta property="og:image" content="<?=base_url('uploads/fdi-banner.jpg');?>">
<meta property="og:image:secure_url" content="<?=base_url('uploads/fdi-banner.jpg');?>" />
<!-- Twitter -->
<meta property="twitter:card" content="summary_large_image">
<meta property="twitter:url" content="<?=base_url();?>">
<meta property="twitter:title" content="<?= isset($page_title) ? $page_title : env('app.Name') ?>">
<meta property="twitter:description" content="<?= isset($page_description) ? $page_description : env('app.Name') ?>">
<meta property="twitter:image" content="<?=base_url('uploads/fdi-banner.jpg');?>">
</head>

<body>
    <!-- preloader -->
    <div class="preloader">
        <div class="preloader-inner">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!-- preloader-end -->
    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
        <i class="fas fa-chevron-up"></i>
    </button>
    <!-- Scroll-top-end-->
    <!-- header-area -->
    <header>
        <div class="tg-header__top">
            <div class="container custom-container">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <div class="tg-header__top-info">
                            <ul class="list-wrap">
                                <li><i class="flaticon-placeholder"></i><?= env('app.Address') ?></li>
                                <li><i class="flaticon-envelope"></i><a href="mailto:<?= env('app.Email') ?>"><?= env('app.Email') ?></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="tg-header__top-right">
                            <ul class="list-wrap">
                                <li><i class="flaticon-clock"></i>Mon - Fri: 9.00am - 7.00pm</li>
                                <li>
                                    <div class="tg-header__top-social">
                                        <ul class="list-wrap">
                                            <li><a href="#" target="_blank"><img src="assets/img/icons/facebook.svg" alt="" class="injectable"></a></li>
                                            <li><a href="#" target="_blank"><img src="assets/img/icons/twitter.svg" alt="" class="injectable"></a></li>
                                            <li><a href="<?= env('app.linkedinUrl') ?>" target="_blank"><img src="assets/img/icons/linkedin.svg" alt="" class="injectable"></a></li>
                                            <li><a href="#" target="_blank"><img src="assets/img/icons/pinterest.svg" alt="" class="injectable"></a></li>
                                        </ul>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="header-fixed-height"></div>
        <div id="sticky-header" class="tg-header__area tg-header__area-seven">
            <div class="container custom-container">
                <div class="tgmenu__wrap">
                    <nav class="tgmenu__nav">
                        <div class="tgmenu__nav-left">
                            <div class="logo">
                                <a href="<?=base_url();?>"><img src="<?=base_url('uploads/logo.png');?>" alt="<?= env('app.Name') ?>"></a>
                            </div>
                            <div class="tgmenu__nav-left-contact">
                                <span>Call Now</span>
                                <a href="tel:<?= env('app.Phone') ?>"><?= env('app.Phone') ?></a>
                            </div>
                        </div>
                        <div class="tgmenu__navbar-wrap tgmenu__main-menu d-none d-lg-flex">
                            <ul class="navigation">
                                <li class="<?php if(current_url() == base_url()){ echo 'active'; } ?>"><a href="<?=base_url();?>">Home</a></li>
                                <li class="menu-item-has-children tg-mega-menu-has-children"><a href="#">Services</a>
                                    <div class="tg-mega-menu-wrap">
                                        <div class="row">
                                            <div class="col-4">
                                                <div class="mega-menu-item">
                                                    <div class="mega-menu-thumb">
                                                        <a href="<?=base_url('service/market-research');?>"><img src="<?=base_url('uploads/services/market-researches.webp');?>" alt="Market Research"></a>
                                                    </div>
                                                    <div class="mega-menu-content">
                                                        <h4 class="title"><a href="#">Market Research</a></h4>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-4">
                                                <div class="mega-menu-item">
                                                    <div class="mega-menu-thumb">
                                                        <a href="<?=base_url('service/background-verification');?>"><img src="<?=base_url('uploads/services/background-verification.webp');?>" alt="Background Verification"></a>
                                                    </div>
                                                    <div class="mega-menu-content">
                                                        <h4 class="title"><a href="#">Background Verification</a></h4>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-4">
                                                <div class="mega-menu-item">
                                                    <div class="mega-menu-thumb">
                                                        <a href="<?=base_url('service/insurance-claim-investigation');?>"><img src="<?=base_url('uploads/services/insurance-claim-investigation.webp');?>" alt="Insurance claim Investigation"></a>
                                                    </div>
                                                    <div class="mega-menu-content">
                                                        <h4 class="title"><a href="#">Insurance claim Investigation</a></h4>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            
                                        </div>
                                    </div>
                                </li>
                                <li class="<?php if(current_url() == base_url('aboutus')){ echo 'active'; } ?>"><a href="<?=base_url('aboutus');?>">About Us</a></li>
                                <li class="<?php if(current_url() == base_url('contactus')){ echo 'active'; } ?>"><a href="<?=base_url('contactus');?>">Contact Us</a></li>
                            </ul>
                        </div>
                        <div class="tgmenu__action tgmenu__action-seven">
                            <ul class="list-wrap">
                               <!--  <li class="header-search">
                                    <a href="javascript:void(0)" class="search-open-btn"><i class="flaticon-search"></i></a>
                                </li> -->
                                <li class="header-btn">
                                    <a href="<?=base_url('contactus');?>" class="tg-btn">Request a Quote</a>
                                </li>
                            </ul>
                        </div>
                        <div class="mobile-nav-toggler"><i class="tg-flaticon-menu"></i></div>
                    </nav>
                </div>
            </div>
        </div>


        <!-- Mobile Menu  -->
        <div class="tgmobile__menu">
            <nav class="tgmobile__menu-box">
                <div class="close-btn"><i class="tg-flaticon-close-1"></i></div>
                <div class="nav-logo">
                    <a href="<?=base_url();?>"><img src="<?=base_url('uploads/logo.png');?>" alt="<?=env('app.Name');?>"></a>
                </div>
                <!-- <div class="tgmobile__search">
                    <form action="#">
                        <input type="text" placeholder="Search here...">
                        <button><i class="fas fa-search"></i></button>
                    </form>
                </div> -->
                <div class="tgmobile__menu-outer">
                    <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                </div>
                <div class="social-links">
                    <ul class="list-wrap">
                        <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                        <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                        <li><a href="#"><i class="fab fa-instagram"></i></a></li>
                        <li><a href="<?= env('app.linkedinUrl') ?>"><i class="fab fa-linkedin-in"></i></a></li>
                        <li><a href="#"><i class="fab fa-youtube"></i></a></li>
                    </ul>
                </div>
            </nav>
        </div>
        <div class="tgmobile__menu-backdrop"></div>
        <!-- End Mobile Menu -->

        <!-- header-search -->
        <div class="search__popup">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="search__wrapper">
                            <div class="search__close">
                                <button type="button" class="search-close-btn">
                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M17 1L1 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path d="M1 1L17 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                    </svg>
                                </button>
                            </div>
                            <div class="search__form">
                                <form action="#">
                                    <div class="search__input">
                                        <input class="search-input-field" type="text" placeholder="Type keywords here">
                                        <span class="search-focus-border"></span>
                                        <button>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.55 18.1C14.272 18.1 18.1 14.272 18.1 9.55C18.1 4.82797 14.272 1 9.55 1C4.82797 1 1 4.82797 1 9.55C1 14.272 4.82797 18.1 9.55 18.1Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M19.0002 19.0002L17.2002 17.2002" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                            </svg>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="search-popup-overlay"></div>
        <!-- header-search-end -->

    </header>
    <!-- header-area-end -->



    <!-- main-area -->
    <main class="main-area fix">
        <?= $this->renderSection('content') ?>
    </main>
    <!-- main-area-end -->

    <!-- footer-area -->
    <footer class="footer__area-two fix">
        <div class="container">
            <div class="footer__top-two">
                <div class="row">
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="footer__widget">
                            <h4 class="footer__widget-title footer__widget-title-two">Information</h4>
                            <div class="footer__contact">
                                <ul class="list-wrap">
                                    <li><i class="flaticon-placeholder"></i><?= env('app.Address') ?></li>
                                    <li><i class="flaticon-telephone"></i><a href="tel:<?= env('app.Phone') ?>"><?= env('app.Phone') ?></a></li>
                                    <li><i class="flaticon-envelope"></i><a href="mailto:<?= env('app.Email') ?>"><?= env('app.Email') ?></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <div class="footer__widget">
                            <h4 class="footer__widget-title footer__widget-title-two">About Company</h4>
                            <ul class="footer__widget-link footer__widget-link-two list-wrap">
                                <li><a href="<?=base_url('aboutus');?>">About Us</a></li>
                                <li><a href="<?=base_url('contactus');?>">Contact Us</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-4 col-md-6 col-sm-6">
                        <div class="footer__widget">
                            <h4 class="footer__widget-title footer__widget-title-two">Quick links</h4>
                            <ul class="footer__widget-link footer__widget-link-two list-wrap">
                                <li><a href="#">How it’s Work</a></li>
                                <li><a href="#">Partners</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <div class="footer__widget">
                            <h4 class="footer__widget-title footer__widget-title-two">Working hours</h4>
                            <ul class="footer__widget-link footer__widget-link-two list-wrap">
                                <li>Mon-Fri: 9 AM – 7 PM</li>
                                <li>Saturday: 9 AM – 7 PM</li>
                                <li>Sunday: Closed</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer__bottom-two footer__bottom-four">
                <div class="row align-items-center">
                    <div class="col-lg-4">
                        <div class="footer__bottom-logo-two">
                            <a href="<?=base_url();?>"><img src="<?=base_url('uploads/logo-white.png');?>" alt="<?= env('app.Name') ?>" style="height: 45px;"></a>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="copyright__content-two text-center">
                            <p>Copyright © <?= env('app.Name') ?> | All Right Reserved</p>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="footer__social footer__social-two">
                            <ul class="list-wrap">
                                <li><a href="#" target="_blank"><img src="assets/img/icons/facebook.svg" alt="" class="injectable"></a></li>
                                <li><a href="#" target="_blank"><img src="assets/img/icons/twitter.svg" alt="" class="injectable"></a></li>
                                <li><a href="<?= env('app.linkedinUrl') ?>" target="_blank"><img src="assets/img/icons/linkedin.svg" alt="" class="injectable"></a></li>
                                <li><a href="#" target="_blank"><img src="assets/img/icons/pinterest.svg" alt="" class="injectable"></a></li>
                                <li><a href="#" target="_blank"><img src="assets/img/icons/youtube.svg" alt="" class="injectable"></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer__shape-wrap-three">
            <img src="<?=base_url();?>assets/img/images/h2_footer_shape02.svg" alt="shape">
            <img src="<?=base_url();?>assets/img/images/h2_footer_shape03.svg" alt="shape">
        </div>
    </footer>
    <!-- footer-area-end -->

    <!-- JS here -->
    <script src="<?=base_url();?>assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="<?=base_url();?>assets/js/bootstrap.min.js"></script>
    <script src="<?=base_url();?>assets/js/jquery.magnific-popup.min.js"></script>
    <script src="<?=base_url();?>assets/js/jquery.odometer.min.js"></script>
    <script src="<?=base_url();?>assets/js/jquery.appear.js"></script>
    <script src="<?=base_url();?>assets/js/swiper-bundle.min.js"></script>
    <script src="<?=base_url();?>assets/js/jquery.parallaxScroll.min.js"></script>
    <script src="<?=base_url();?>assets/js/jquery.marquee.min.js"></script>
    <script src="<?=base_url();?>assets/js/tg-cursor.min.js"></script>
    <script src="<?=base_url();?>assets/js/ajax-form.js"></script>
    <script src="<?=base_url();?>assets/js/svg-inject.min.js"></script>
    <script src="<?=base_url();?>assets/js/wow.min.js"></script>
    <script src="<?=base_url();?>assets/js/aos.js"></script>
    <script src="<?=base_url();?>assets/js/main.js"></script>
    <script>
        SVGInject(document.querySelectorAll("img.injectable"));
    </script>
    <script>
        function rangeSlide(value) {
            document.getElementById('rangeValue').innerHTML = value;
            document.getElementById('rangeValueTwo').innerHTML = value;
            document.getElementById('rangeValueThree').innerHTML = value;
            document.getElementById('rangeValueFour').innerHTML = value;
        }
    </script>
</body>

</html>