<?= $this->extend('base') ?>
<?= $this->section('content') ?>
<!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Contact With Us</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?=base_url();?>">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Contact</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->
        <!-- contact-map -->
        <div class="contact-map">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3503.2161677827244!2d77.45004967608972!3d28.59329117568618!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390cef9f083de41d%3A0xb1ce9057bed0a641!2sJM%20Florence!5e0!3m2!1sen!2sin!4v1741777142846!5m2!1sen!2sin" allowfullscreen loading="lazy"></iframe>
        </div>
        <!-- contact-map-end -->

        <!-- contact-area -->
        <section class="contact__area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="contact__info-wrap">
                            <div class="contact__info-item">
                                <h4 class="title">Noida City</h4>
                                <p><?= env('app.Address');?></p>
                                <ul class="list-wrap">
                                    <li>
                                        <a href="tel:<?= env('app.Phone');?>"><?= env('app.Phone');?></a>
                                    </li>
                                    <li>
                                        <a href="mailto:<?= env('app.Email');?>"><?= env('app.Email');?></a>
                                    </li>
                                </ul>
                                <div class="shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="174" height="210" viewBox="0 0 174 210" fill="none">
                                        <path d="M168.636 86.8182C168.636 150.455 86.8182 205 86.8182 205C86.8182 205 5 150.455 5 86.8182C5 65.1187 13.6201 44.3079 28.964 28.964C44.3079 13.6201 65.1187 5 86.8182 5C108.518 5 129.328 13.6201 144.672 28.964C160.016 44.3079 168.636 65.1187 168.636 86.8182Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                                        <path d="M86.8182 114.091C101.88 114.091 114.091 101.88 114.091 86.8182C114.091 71.7559 101.88 59.5455 86.8182 59.5455C71.7559 59.5455 59.5455 71.7559 59.5455 86.8182C59.5455 101.88 71.7559 114.091 86.8182 114.091Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </div>
                            <div class="contact__info-item">
                                <h4 class="title">Noida (U.P.)</h4>
                                <p><?= env('app.Address');?></p>
                                <ul class="list-wrap">
                                    <li>
                                        <a href="tel:<?= env('app.Phone');?>"><?= env('app.Phone');?></a>
                                    </li>
                                    <li>
                                        <a href="mailto:<?= env('app.Email');?>"><?= env('app.Email');?></a>
                                    </li>
                                </ul>
                                <div class="shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="174" height="210" viewBox="0 0 174 210" fill="none">
                                        <path d="M168.636 86.8182C168.636 150.455 86.8182 205 86.8182 205C86.8182 205 5 150.455 5 86.8182C5 65.1187 13.6201 44.3079 28.964 28.964C44.3079 13.6201 65.1187 5 86.8182 5C108.518 5 129.328 13.6201 144.672 28.964C160.016 44.3079 168.636 65.1187 168.636 86.8182Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                                        <path d="M86.8182 114.091C101.88 114.091 114.091 101.88 114.091 86.8182C114.091 71.7559 101.88 59.5455 86.8182 59.5455C71.7559 59.5455 59.5455 71.7559 59.5455 86.8182C59.5455 101.88 71.7559 114.091 86.8182 114.091Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="contact__form-wrap">
                            <h2 class="title">Leave Us A Message</h2>
                            <?php if(session()->getFlashdata('msg')):?>
                        <div class="alert alert-warning alert-dismissible fade show text-center small" role="alert">
                            <?= session()->getFlashdata('msg') ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif;?>
                    <?php echo form_open('enquiry', 'class="contact__form" '); ?>
                                <div class="form-grp">
                                    <label for="name">Name *</label>
                                    <input id="name" name="name" type="text" required>
                                </div>
                                <div class="form-grp">
                                    <label for="email">Email *</label>
                                    <input id="email" name="email" type="email" required>
                                <div class="form-grp">
                                    <label for="phone">Phone *</label>
                                    <input id="phone" name="phone" type="tel" required>
                                </div>
                                <div class="form-grp">
                                    <label for="comment">Comment *</label>
                                    <textarea name="message" id="comment" required></textarea>
                                </div>
                                <!-- <div class="form-grp checkbox-grp">
                                    <input type="checkbox" id="checkbox">
                                    <label for="checkbox">Save my name, email, and website in this browser for the next time I comment.</label>
                                </div> -->
                                <button type="submit" class="tg-btn tg-btn-three">Submit Message</button>
                            </form>
                            <p class="ajax-response mb-0"></p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- contact-area-end -->

        <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">Let’s Request a Schedule For Free Consultation</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-telephone"></i>
                                    </div>
                                    <div class="content">
                                        <span>Call For More Info</span>
                                        <a href="tel:<?= env('app.Phone');?>"><?= env('app.Phone');?></a>
                                    </div>
                                </div>
                                <a href="<?=base_url('aboutus');?>" class="tg-btn tg-btn-three tg-border-btn ">Read More <img src="<?=base_url();?>assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="<?=base_url();?>assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->
<?= $this->endSection() ?>